import bpy
from bpy.types import Context, Material
from .libraries import append_from_library
from ...addon.paths import FluidLabPaths
from ...addon.naming import FluidLabNaming


def append_material(context:Context, blend_file:str, material_name:str) -> Material:

    total = len([ng for ng in bpy.data.node_groups if ng.name.startswith(material_name)])
    padding = len(str(total))+1
    new_name = material_name + "_" + str(total).zfill(padding)

    append_from_library(
        context,
        FluidLabPaths.LIBS_MATERIALS_PATH,
        "Material",
        blend_file + ".blend",
        material_name,
        only_if_not_exist=True
    )
    
    mat = bpy.data.materials.get(material_name)
    if mat:
        mat.name = new_name
        mat[FluidLabNaming.FLUIDLAB_MAT] = True
        return mat